<?php
session_start();
include('connection.php');
if (!isset($_SESSION['admin_login'])) {
    echo "<script>window.location='login.php';</script>";
    exit;
}
$admin_username = $_SESSION['admin_login'];
$_SESSION['user_type'] = 'Admin';

// List of Tanzanian subjects with their table names
$subjects = [
    'Mathematics' => 'mathematics',
    'English' => 'english',
    'Kiswahili' => 'kiswahili',
    'Physics' => 'physics',
    'Chemistry' => 'chemistry',
    'Biology' => 'biology',
    'Geography' => 'geography',
    'History' => 'history',
    'Civics' => 'civics',
    'French' => 'french',
    'Literature' => 'literature'
];

// Grade and point calculation function
function calculateGradeAndPoint($score)
{
    if ($score >= 75) return [1, 'A'];
    if ($score >= 65) return [2, 'B'];
    if ($score >= 45) return [3, 'C'];
    if ($score >= 30) return [4, 'D'];
    return [5, 'F'];
}

// Division calculation function
function calculateDivision($total_points)
{
    if ($total_points >= 7 && $total_points <= 17) return "I";
    if ($total_points >= 18 && $total_points <= 21) return "II";
    if ($total_points >= 22 && $total_points <= 25) return "III";
    if ($total_points >= 26 && $total_points <= 33) return "IV";
    return "0";
}

// Handle form submission
$results = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $class = $_POST['class'];
    $exam_type = $_POST['exam_type'];
    $year = $_POST['year'];

    // Ensure user-provided values are sanitized
    $stmt = $con->prepare("SELECT DISTINCT registration_number, full_name, gender FROM students WHERE class = ?");
    $stmt->bind_param("s", $class);
    $stmt->execute();
    $students = $stmt->get_result();

    $results = [];

    while ($student = $students->fetch_assoc()) {
        $registration_number = $student['registration_number'];
        $subject_grades = [];
        $points = [];
        $total_score = 0;

        foreach ($subjects as $subject_name => $table_name) {
            // Fetch subject score for the specific student
            $score_query = $con->prepare("
                SELECT score FROM $table_name 
                WHERE registration_number = ? AND class = ? AND exam_type = ? AND year = ?");
            $score_query->bind_param("ssss", $registration_number, $class, $exam_type, $year);
            $score_query->execute();
            $score_result = $score_query->get_result();
            $score_row = $score_result->fetch_assoc();

            // Calculate grade and points for each subject
            $score = $score_row['score'] ?? null;
            if ($score !== null) {
                list($point, $grade) = calculateGradeAndPoint($score);
                $subject_grades[$subject_name] = $grade;
                $points[] = $point;
                $total_score += $score; // Sum up scores
            } else {
                $subject_grades[$subject_name] = 'N/A';
            }
        }

        // Calculate final results
        sort($points);
        $total_points = array_sum(array_slice($points, 0, 7)); // Consider 7 best scores
        $division = calculateDivision($total_points);
        $average_score = $total_score / count(array_filter($subject_grades, fn($g) => $g !== 'N/A'));

        $results[] = [
            'registration_number' => $registration_number,
            'full_name' => $student['full_name'],
            'gender' => $student['gender'],
            'grades' => $subject_grades,
            'total_points' => $total_points,
            'division' => $division,
            'total_score' => $total_score,
            'average_score' => number_format($average_score, 2)
        ];
    }

    // Alert if no results found
    if (empty($results)) {
        echo "<script>alert('No results found for the selected inputs. Please check your selection and try again.');</script>";
    }

    // Sort results by registration_number using natural order
    usort($results, function ($a, $b) {
        return strnatcmp($a['registration_number'], $b['registration_number']);
    });
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin | View Results</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding-top: 70px;
        }
        footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            height: 60px;
            background-color: #f8f9fa;
            border-top: 1px solid #dee2e6;
            text-align: center;
            line-height: 60px;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-light fixed-top">
    <a class="navbar-brand" href="#">Admin Dashboard</a>
    <div class="collapse navbar-collapse">
        <ul class="navbar-nav mr-auto">
            <li class="nav-item active">
                <a class="nav-link" href="#">/ View Results</a>
            </li>
        </ul>
        <span class="navbar-text">Welcome, <?php echo htmlspecialchars($admin_username); ?>!</span>
    </div>
</nav>

<div class="container mt-5">
    <h2>View School Results</h2>

    <form method="POST" class="mb-4">
        <div class="row">
            <div class="form-group col-md-4">
                <label for="class">Class</label>
                <select name="class" id="class" class="form-control" required>
                    <option value="">Select Class</option>
                    <option value="Form One">Form One</option>
                    <option value="Form Two">Form Two</option>
                    <option value="Form Three">Form Three</option>
                    <option value="Form Four">Form Four</option>
                </select>
            </div>
            <div class="form-group col-md-4">
                <label for="exam_type">Exam Type</label>
                 <select name="exam_type" id="exam_type" class="form-control" required>
                <option value="">Select Exam Type</option>
                <option value="Midterm_1_Examination">Midterm 1 Examination</option>
                <option value="Terminal_Examination">Terminal Examination</option>
                <option value="Midterm_2_Examination">Midterm 2 Examination</option>
                <option value="Annual_Examination">Annual Examination</option>
                <option value="Mock_Examination">Mock Examination</option>
            </select>
            </div>
            <div class="form-group col-md-4">
                <label for="year">Year</label>
                <select name="year" id="year" class="form-control" required>
                    <?php
                    $currentYear = date('Y');
                    for ($year = 2010; $year <= $currentYear; $year++) {
                        echo "<option value='$year'>$year</option>";
                    }
                    ?>
                </select>
            </div>
        </div>
        <button type="submit" class="btn btn-primary btn-block">Fetch Results</button>
    </form>

    <?php if (!empty($results)): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Reg Number</th>
                        <th>Full Name</th>
                        <th>Gender</th>
                        <?php foreach ($subjects as $subject_name => $table_name): ?>
                            <th><?php echo $subject_name; ?></th>
                        <?php endforeach; ?>
                        <th>Score</th>
                        <th>Average</th>
                        <th>Points</th>
                        <th>Division</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($results as $result): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($result['registration_number']); ?></td>
                            <td><?php echo htmlspecialchars($result['full_name']); ?></td>
                            <td><?php echo htmlspecialchars($result['gender']); ?></td>
                            <?php foreach ($subjects as $subject_name => $table_name): ?>
                                <td><?php echo htmlspecialchars($result['grades'][$subject_name]); ?></td>
                            <?php endforeach; ?>
                            <td><?php echo htmlspecialchars($result['total_score']); ?></td>
                            <td><?php echo htmlspecialchars($result['average_score']); ?></td>
                            <td><?php echo htmlspecialchars($result['total_points']); ?></td>
                            <td><?php echo htmlspecialchars($result['division']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>
<br><br>
<footer>
    &copy; <?php echo date("Y"); ?> Mwalongo Secondary School. All Rights Reserved.
</footer>
</body>
</html>
